<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

$token = $_GET['token'] ?? '';

if (!$token) {
    redirect('index.php');
}

try {
    // Teklif ve ödeme bilgilerini al
    $stmt = $pdo->prepare("
        SELECT q.*, qr.id as request_id,
               c.first_name, c.last_name, c.phone, c.email,
               v.brand, v.model, v.year,
               p.amount, p.payment_method, p.installments, p.processed_at,
               o.order_number, o.id as order_id
        FROM quotes q
        JOIN quote_requests qr ON q.quote_request_id = qr.id
        JOIN customers c ON qr.customer_id = c.id
        JOIN vehicles v ON qr.vehicle_id = v.id
        JOIN payments p ON q.id = p.quote_id AND p.status = 'completed'
        JOIN orders o ON q.id = o.quote_id
        WHERE q.quote_token = ?
    ");
    $stmt->execute([$token]);
    $data = $stmt->fetch();
    
    if (!$data) {
        redirect('index.php');
    }
    
} catch (Exception $e) {
    error_log("Payment success page error: " . $e->getMessage());
    redirect('index.php');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ödeme Başarılı - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-car"></i> Araç Bakım Servisi
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">
                    <i class="fas fa-home"></i> Ana Sayfa
                </a>
            </div>
        </div>
    </nav>

    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <!-- Başarı Mesajı -->
                <div class="card shadow-lg form-success">
                    <div class="card-body text-center p-5">
                        <div class="mb-4">
                            <i class="fas fa-check-circle text-success fa-5x bounce-in"></i>
                        </div>
                        
                        <h2 class="text-success mb-4">Ödeme Başarılı!</h2>
                        
                        <p class="lead mb-4">
                            Sayın <strong><?= h($data['first_name'] . ' ' . $data['last_name']) ?></strong>,<br>
                            Ödemeniz başarıyla tamamlanmıştır. Siparişiniz oluşturuldu.
                        </p>
                        
                        <div class="alert alert-success">
                            <h5><i class="fas fa-info-circle"></i> Sipariş Bilgileri</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Sipariş No:</strong> <?= h($data['order_number']) ?></p>
                                    <p><strong>Teklif No:</strong> <?= h($data['quote_number']) ?></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Ödeme Tarihi:</strong> <?= formatDate($data['processed_at']) ?></p>
                                    <p><strong>Tutar:</strong> <?= formatMoney($data['amount']) ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Ödeme Detayları -->
                <div class="card shadow-lg mt-4">
                    <div class="card-header">
                        <h5><i class="fas fa-receipt"></i> Ödeme Detayları</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Müşteri Bilgileri</h6>
                                <p class="mb-1"><strong><?= h($data['first_name'] . ' ' . $data['last_name']) ?></strong></p>
                                <p class="mb-1"><?= h($data['phone']) ?></p>
                                <?php if ($data['email']): ?>
                                <p class="mb-0"><?= h($data['email']) ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <h6>Araç Bilgileri</h6>
                                <p class="mb-0"><?= h($data['brand'] . ' ' . $data['model'] . ' (' . $data['year'] . ')') ?></p>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Ödeme Bilgileri</h6>
                                <p class="mb-1">
                                    <strong>Yöntem:</strong> 
                                    <?= $data['payment_method'] === 'credit_card' ? 'Kredi Kartı' : 'Havale/EFT' ?>
                                </p>
                                <?php if ($data['installments'] > 1): ?>
                                <p class="mb-1"><strong>Taksit:</strong> <?= $data['installments'] ?> Taksit</p>
                                <?php endif; ?>
                                <p class="mb-0"><strong>Tutar:</strong> <?= formatMoney($data['amount']) ?></p>
                            </div>
                            <div class="col-md-6">
                                <h6>Sipariş Durumu</h6>
                                <span class="badge bg-warning">Onay Bekliyor</span>
                                <p class="small text-muted mt-2">
                                    Siparişiniz en kısa sürede onaylanacak ve size bilgi verilecektir.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sonraki Adımlar -->
                <div class="card shadow-lg mt-4">
                    <div class="card-header">
                        <h5><i class="fas fa-tasks text-primary"></i> Sonraki Adımlar</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="step-item text-center">
                                    <div class="step-icon mb-3">
                                        <i class="fas fa-check-circle fa-2x text-success"></i>
                                    </div>
                                    <h6>1. Ödeme Tamamlandı</h6>
                                    <p class="small text-muted">Ödemeniz başarıyla alındı</p>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="step-item text-center">
                                    <div class="step-icon mb-3">
                                        <i class="fas fa-clock fa-2x text-warning"></i>
                                    </div>
                                    <h6>2. Sipariş Onayı</h6>
                                    <p class="small text-muted">Ekibimiz siparişinizi onaylayacak</p>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="step-item text-center">
                                    <div class="step-icon mb-3">
                                        <i class="fas fa-calendar-alt fa-2x text-info"></i>
                                    </div>
                                    <h6>3. Randevu</h6>
                                    <p class="small text-muted">Size uygun randevu belirlenecek</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle"></i> Önemli Bilgiler</h6>
                            <ul class="mb-0">
                                <li>Siparişiniz 1 iş günü içinde onaylanacaktır</li>
                                <li>Randevu tarihi SMS ile bildirilecektir</li>
                                <li>Herhangi bir sorunuz için bizi arayabilirsiniz: <strong>0212 123 45 67</strong></li>
                                <li>Sipariş durumunuzu takip etmek için sipariş numaranızı saklayın</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- İşlem Butonları -->
                <div class="card shadow-lg mt-4">
                    <div class="card-body text-center">
                        <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                            <button class="btn btn-primary btn-lg me-md-2" onclick="window.print()">
                                <i class="fas fa-print"></i> Makbuz Yazdır
                            </button>
                            <a href="tel:02121234567" class="btn btn-success btn-lg me-md-2">
                                <i class="fas fa-phone"></i> Bizi Arayın
                            </a>
                            <a href="index.php" class="btn btn-outline-secondary btn-lg">
                                <i class="fas fa-home"></i> Ana Sayfaya Dön
                            </a>
                        </div>
                        
                        <hr class="my-4">
                        
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="text-center">
                                    <i class="fas fa-shield-alt fa-2x text-success mb-2"></i>
                                    <h6>Güvenli Ödeme</h6>
                                    <small class="text-muted">256-bit SSL şifreleme ile korundu</small>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="text-center">
                                    <i class="fas fa-medal fa-2x text-warning mb-2"></i>
                                    <h6>2 Yıl Garanti</h6>
                                    <small class="text-muted">Tüm parçalar için garanti</small>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="text-center">
                                    <i class="fas fa-headset fa-2x text-info mb-2"></i>
                                    <h6>7/24 Destek</h6>
                                    <small class="text-muted">Sürekli müşteri desteği</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4 mt-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-car fa-2x text-warning me-3"></i>
                        <div>
                            <h6 class="mb-0">Araç Bakım Servisi</h6>
                            <small>Profesyonel araç bakım hizmetleri</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">
                        <i class="fas fa-phone"></i> 0212 123 45 67 |
                        <i class="fas fa-envelope"></i> info@aracbakim.com
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
        // Sayfa yüklendiğinde konfeti animasyonu
        document.addEventListener('DOMContentLoaded', function() {
            // Kartları sırayla göster
            const cards = document.querySelectorAll('.card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                
                setTimeout(() => {
                    card.style.transition = 'all 0.5s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 300);
            });

            // Başarı ikonunu büyüt
            setTimeout(() => {
                const icon = document.querySelector('.fa-check-circle');
                if (icon) {
                    icon.style.transform = 'scale(1.2)';
                    setTimeout(() => {
                        icon.style.transform = 'scale(1)';
                    }, 300);
                }
            }, 500);
        });

        // Otomatik yönlendirme (opsiyonel)
        // setTimeout(() => {
        //     if (confirm('Ana sayfaya yönlendirilmek istiyor musunuz?')) {
        //         window.location.href = 'index.php';
        //     }
        // }, 30000); // 30 saniye sonra
    </script>

    <style>
        .step-item {
            transition: transform 0.3s ease;
        }
        
        .step-item:hover {
            transform: translateY(-5px);
        }
        
        .step-icon {
            transition: transform 0.3s ease;
        }
        
        .step-item:hover .step-icon {
            transform: scale(1.1);
        }
        
        @media print {
            .btn, .no-print {
                display: none !important;
            }
            
            .card {
                border: 1px solid #ddd !important;
                box-shadow: none !important;
            }
        }
    </style>
</body>
</html>
