<?php
// Müşteri için genel teklif görüntüleme sayfası (admin girişi gerektirmez)
require_once '../config/config.php';
require_once '../includes/functions.php';

$token = $_GET['token'] ?? '';
if (empty($token)) {
    die('Geçersiz teklif linki.');
}

try {
    // Teklif bilgilerini al
    $stmt = $pdo->prepare("
        SELECT q.*, qr.customer_id, qr.vehicle_id,
               c.first_name, c.last_name, c.email, c.phone,
               v.brand, v.model, v.year, v.plate
        FROM quotes q
        JOIN quote_requests qr ON q.quote_request_id = qr.id
        JOIN customers c ON qr.customer_id = c.id
        JOIN vehicles v ON qr.vehicle_id = v.id
        WHERE q.quote_token = ?
    ");
    $stmt->execute([$token]);
    $quote = $stmt->fetch();
    
    if (!$quote) {
        die('Teklif bulunamadı veya süresi dolmuş.');
    }
    
    // Teklif kalemlerini al
    $stmt = $pdo->prepare("
        SELECT qi.*, p.name as product_name, p.type
        FROM quote_items qi
        LEFT JOIN products p ON qi.product_id = p.id
        WHERE qi.quote_id = ?
        ORDER BY qi.sort_order
    ");
    $stmt->execute([$quote['id']]);
    $quote_items = $stmt->fetchAll();
    
    // Görüntüleme zamanını güncelle
    if (!$quote['viewed_at']) {
        $stmt = $pdo->prepare("UPDATE quotes SET viewed_at = NOW() WHERE id = ?");
        $stmt->execute([$quote['id']]);
    }
    
} catch (Exception $e) {
    error_log("Public quote view error: " . $e->getMessage());
    die('Bir hata oluştu.');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teklif Görüntüle - <?= h($quote['quote_number']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .quote-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
            margin: 2rem 0;
        }
        .quote-header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            color: white;
            padding: 2rem;
            border-radius: 20px 20px 0 0;
            text-align: center;
        }
        .quote-content {
            padding: 2rem;
        }
        .info-card {
            background: #f8fafc;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            border-left: 4px solid #3b82f6;
        }
        .item-card {
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 1rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        .item-card:hover {
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .total-section {
            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
            border-radius: 12px;
            padding: 1.5rem;
            border: 2px solid #3b82f6;
        }
        .btn-view-customer {
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            border: none;
            color: white;
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }
        .btn-view-customer:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(5, 150, 105, 0.3);
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="quote-container">
                    <!-- Header -->
                    <div class="quote-header">
                        <h1><i class="fas fa-file-invoice"></i> Teklif Detayları</h1>
                        <p class="mb-0">Teklif No: <strong><?= h($quote['quote_number']) ?></strong></p>
                        <small>Oluşturma: <?= date('d.m.Y H:i', strtotime($quote['created_at'])) ?></small>
                    </div>
                    
                    <!-- Content -->
                    <div class="quote-content">
                        <!-- Müşteri Bilgileri -->
                        <div class="info-card">
                            <h5><i class="fas fa-user text-primary"></i> Müşteri Bilgileri</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Ad Soyad:</strong> <?= h($quote['first_name'] . ' ' . $quote['last_name']) ?></p>
                                    <p><strong>E-posta:</strong> <?= h($quote['email']) ?></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Telefon:</strong> <?= h($quote['phone']) ?></p>
                                    <p><strong>Araç:</strong> <?= h($quote['brand'] . ' ' . $quote['model'] . ' (' . $quote['year'] . ')') ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Teklif Kalemleri -->
                        <h5><i class="fas fa-list text-primary"></i> Teklif Kalemleri</h5>
                        <?php if (empty($quote_items)): ?>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> Bu teklifte henüz ürün/hizmet bulunmuyor.
                            </div>
                        <?php else: ?>
                            <?php foreach ($quote_items as $item): ?>
                            <div class="item-card">
                                <div class="row align-items-center">
                                    <div class="col-md-6">
                                        <h6 class="mb-1"><?= h($item['name']) ?></h6>
                                        <?php if ($item['product_name']): ?>
                                            <small class="text-success"><i class="fas fa-check"></i> Sistem Ürünü</small>
                                        <?php else: ?>
                                            <small class="text-info"><i class="fas fa-tools"></i> Özel Hizmet</small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-2 text-center">
                                        <strong>Miktar:</strong><br>
                                        <span class="badge bg-primary"><?= $item['quantity'] ?></span>
                                    </div>
                                    <div class="col-md-2 text-center">
                                        <strong>Birim Fiyat:</strong><br>
                                        <?= formatMoney($item['unit_price']) ?>
                                    </div>
                                    <div class="col-md-2 text-center">
                                        <strong>Toplam:</strong><br>
                                        <span class="text-success fw-bold"><?= formatMoney($item['line_total']) ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        
                        <!-- Toplam Hesaplama -->
                        <div class="total-section mt-4">
                            <div class="row">
                                <div class="col-md-8">
                                    <h5><i class="fas fa-calculator text-primary"></i> Fiyat Özeti</h5>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Ara Toplam:</span>
                                        <strong><?= formatMoney($quote['subtotal']) ?></strong>
                                    </div>
                                    <?php if ($quote['discount_percentage'] > 0): ?>
                                    <div class="d-flex justify-content-between mb-2 text-success">
                                        <span>İndirim (%<?= $quote['discount_percentage'] ?>):</span>
                                        <strong>-<?= formatMoney($quote['discount_amount']) ?></strong>
                                    </div>
                                    <?php endif; ?>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>KDV (%<?= $quote['tax_rate'] * 100 ?>):</span>
                                        <strong><?= formatMoney($quote['tax_amount']) ?></strong>
                                    </div>
                                    <hr>
                                    <div class="d-flex justify-content-between">
                                        <h5>Genel Toplam:</h5>
                                        <h5 class="text-success"><?= formatMoney($quote['total_amount']) ?></h5>
                                    </div>
                                </div>
                                <div class="col-md-4 text-center">
                                    <h6>Geçerlilik Süresi</h6>
                                    <p class="mb-3"><?= date('d.m.Y H:i', strtotime($quote['valid_until'])) ?></p>
                                    
                                    <a href="../view_quote.php?token=<?= h($token) ?>" class="btn-view-customer">
                                        <i class="fas fa-shopping-cart"></i><br>
                                        Müşteri Görünümü<br>
                                        <small>Sepet Oluştur</small>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Şartlar ve Koşullar -->
                        <?php if ($quote['terms_conditions']): ?>
                        <div class="info-card mt-4">
                            <h5><i class="fas fa-file-contract text-primary"></i> Şartlar ve Koşullar</h5>
                            <p><?= nl2br(h($quote['terms_conditions'])) ?></p>
                        </div>
                        <?php endif; ?>
                        
                        <!-- İletişim -->
                        <div class="text-center mt-4">
                            <h6>Sorularınız için bizimle iletişime geçin:</h6>
                            <p>
                                <a href="tel:02121234567" class="btn btn-outline-primary me-2">
                                    <i class="fas fa-phone"></i> 0212 123 45 67
                                </a>
                                <a href="mailto:<?= ADMIN_EMAIL ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-envelope"></i> E-posta Gönder
                                </a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
