<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

// Giriş kontrolü
if (!isLoggedIn()) {
    redirect('login.php');
}

// Dashboard istatistikleri
try {
    // Bugünkü teklif başvuruları
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE DATE(created_at) = CURDATE()");
    $stmt->execute();
    $todayQuotes = $stmt->fetch()['count'];
    
    // Bu ayki toplam başvuru
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())");
    $stmt->execute();
    $monthlyQuotes = $stmt->fetch()['count'];
    
    // Bekleyen başvurular
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE status = 'NEW'");
    $stmt->execute();
    $pendingQuotes = $stmt->fetch()['count'];
    
    // Bu ayki toplam satış
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(total_amount), 0) as total FROM orders WHERE status = 'completed' AND MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())");
    $stmt->execute();
    $monthlySales = $stmt->fetch()['total'];
    
    // Son başvurular
    $stmt = $pdo->prepare("
        SELECT qr.*, c.first_name, c.last_name, c.phone, v.brand, v.model, v.year
        FROM quote_requests qr
        JOIN customers c ON qr.customer_id = c.id
        JOIN vehicles v ON qr.vehicle_id = v.id
        ORDER BY qr.created_at DESC
        LIMIT 10
    ");
    $stmt->execute();
    $recentQuotes = $stmt->fetchAll();
    
} catch (Exception $e) {
    error_log("Dashboard error: " . $e->getMessage());
    $todayQuotes = $monthlyQuotes = $pendingQuotes = $monthlySales = 0;
    $recentQuotes = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body class="nice-body">
    <!-- NiceAdmin Sidebar -->
    <aside id="sidebar" class="nice-sidebar">
        <ul class="sidebar-nav" id="sidebar-nav">
            <li class="nav-item">
                <a class="nav-link" href="dashboard.php">
                    <div class="text-center mb-4 p-3">
                        <i class="fas fa-car text-primary fa-2x"></i>
                        <h6 class="text-primary mt-2 mb-0">Araç Bakım</h6>
                    </div>
                </a>
            </li>
                    <div class="text-center mb-4">
                        <i class="fas fa-car text-primary fa-2x"></i>
                        <h6 class="text-white mt-2">Araç Bakım</h6>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="dashboard.php">
                                <i class="fas fa-tachometer-alt"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="quotes.php">
                                <i class="fas fa-clipboard-list"></i> Teklif Başvuruları
                                <?php if ($pendingQuotes > 0): ?>
                                    <span class="badge bg-danger ms-2"><?= $pendingQuotes ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="orders.php">
                                <i class="fas fa-shopping-cart"></i> Siparişler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="customers.php">
                                <i class="fas fa-users"></i> Müşteriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="products.php">
                                <i class="fas fa-box"></i> Ürün/Hizmetler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reports.php">
                                <i class="fas fa-chart-bar"></i> Raporlar
                            </a>
                        </li>
                        <?php if (isAdmin()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="settings.php">
                                <i class="fas fa-cog"></i> Ayarlar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="users.php">
                                <i class="fas fa-user-cog"></i> Kullanıcılar
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                    
                    <hr class="my-3">
                    
                    <div class="dropdown">
                        <a href="#" class="nav-link dropdown-toggle text-white" data-bs-toggle="dropdown">
                            <i class="fas fa-user"></i> <?= h($_SESSION['user_name']) ?>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user-edit"></i> Profil</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a></li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- Flutter-Style Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4" style="margin-left: 16.66667% !important;">
                <div class="flutter-card p-4 mb-4">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center">
                        <div>
                            <h1 class="h2 fw-bold mb-1">
                                <i class="fas fa-tachometer-alt text-primary me-2"></i>Dashboard
                            </h1>
                            <p class="text-muted mb-0">Sistem genel durumu ve istatistikler</p>
                        </div>
                        <div class="btn-toolbar">
                            <button type="button" class="flutter-btn flutter-btn-outlined" onclick="location.reload()">
                                <i class="fas fa-sync-alt me-2"></i>Yenile
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Flutter-Style İstatistik Kartları -->
                <div class="row g-4 mb-5">
                    <div class="col-xl-3 col-md-6">
                        <div class="flutter-stat-card">
                            <div class="flutter-stat-icon">
                                <i class="fas fa-calendar-day"></i>
                            </div>
                            <div class="flutter-stat-number"><?= $todayQuotes ?></div>
                            <div class="flutter-stat-label">Bugünkü Başvuru</div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6">
                        <div class="flutter-stat-card">
                            <div class="flutter-stat-icon">
                                <i class="fas fa-hourglass-half"></i>
                            </div>
                            <div class="flutter-stat-number"><?= $pendingQuotes ?></div>
                            <div class="flutter-stat-label">Bekleyen Başvuru</div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6">
                        <div class="flutter-stat-card">
                            <div class="flutter-stat-icon">
                                <i class="fas fa-calendar-alt"></i>
                            </div>
                            <div class="flutter-stat-number"><?= $monthlyQuotes ?></div>
                            <div class="flutter-stat-label">Aylık Başvuru</div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6">
                        <div class="flutter-stat-card">
                            <div class="flutter-stat-icon">
                                <i class="fas fa-lira-sign"></i>
                            </div>
                            <div class="flutter-stat-number"><?= formatMoney($monthlySales) ?></div>
                            <div class="flutter-stat-label">Aylık Satış</div>
                        </div>
                    </div>
                </div>

                <!-- Son Başvurular -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5><i class="fas fa-list"></i> Son Teklif Başvuruları</h5>
                            </div>
                            <div class="card-body">
                                <?php if (empty($recentQuotes)): ?>
                                    <div class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Henüz teklif başvurusu bulunmuyor.</p>
                                    </div>
                                <?php else: ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Müşteri</th>
                                                    <th>Telefon</th>
                                                    <th>Araç</th>
                                                    <th>Durum</th>
                                                    <th>Tarih</th>
                                                    <th>İşlemler</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($recentQuotes as $quote): ?>
                                                <tr>
                                                    <td><strong>#<?= $quote['id'] ?></strong></td>
                                                    <td><?= h($quote['first_name'] . ' ' . $quote['last_name']) ?></td>
                                                    <td><?= h($quote['phone']) ?></td>
                                                    <td><?= h($quote['brand'] . ' ' . $quote['model'] . ' (' . $quote['year'] . ')') ?></td>
                                                    <td>
                                                        <?php
                                                        $statusClass = [
                                                            'NEW' => 'badge-new',
                                                            'IN_PROGRESS' => 'badge-in-progress',
                                                            'QUOTE_SENT' => 'badge-info',
                                                            'PAID' => 'badge-completed',
                                                            'EXPIRED' => 'badge-cancelled',
                                                            'CANCELLED' => 'badge-cancelled'
                                                        ];
                                                        $statusText = [
                                                            'NEW' => 'Yeni',
                                                            'IN_PROGRESS' => 'İşlemde',
                                                            'QUOTE_SENT' => 'Teklif Gönderildi',
                                                            'PAID' => 'Ödendi',
                                                            'EXPIRED' => 'Süresi Doldu',
                                                            'CANCELLED' => 'İptal'
                                                        ];
                                                        ?>
                                                        <span class="badge <?= $statusClass[$quote['status']] ?? 'badge-secondary' ?>">
                                                            <?= $statusText[$quote['status']] ?? $quote['status'] ?>
                                                        </span>
                                                    </td>
                                                    <td><?= formatDate($quote['created_at'], 'd.m.Y H:i') ?></td>
                                                    <td>
                                                        <div class="btn-group btn-group-sm">
                                                            <a href="quote_detail.php?id=<?= $quote['id'] ?>" class="btn btn-outline-primary" title="Detay">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <?php if ($quote['status'] === 'NEW'): ?>
                                                            <a href="create_quote.php?request_id=<?= $quote['id'] ?>" class="btn btn-outline-success" title="Teklif Hazırla">
                                                                <i class="fas fa-plus"></i>
                                                            </a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <div class="text-center mt-3">
                                        <a href="quotes.php" class="btn btn-primary">
                                            <i class="fas fa-list"></i> Tüm Başvuruları Görüntüle
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Mobile Sidebar Toggle -->
    <button class="btn btn-primary d-md-none position-fixed" id="sidebarToggle" style="top: 10px; left: 10px; z-index: 1001;">
        <i class="fas fa-bars"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/main.js"></script>
    <script>
        // Auto-refresh dashboard every 5 minutes
        setInterval(() => {
            location.reload();
        }, 300000);
        
        // Real-time clock
        function updateClock() {
            const now = new Date();
            const timeString = now.toLocaleTimeString('tr-TR');
            document.title = `Dashboard - ${timeString} - Araç Bakım Servisi`;
        }
        
        setInterval(updateClock, 1000);
        updateClock();
    </script>
</body>
</html>
