<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

// Giriş kontrolü
if (!isLoggedIn()) {
    redirect('login.php');
}

// Dashboard istatistikleri
try {
    // Bugünkü teklif başvuruları
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE DATE(created_at) = CURDATE()");
    $stmt->execute();
    $todayQuotes = $stmt->fetch()['count'];
    
    // Bu ayki toplam başvuru
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())");
    $stmt->execute();
    $monthlyQuotes = $stmt->fetch()['count'];
    
    // Bekleyen başvurular
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE status = 'NEW'");
    $stmt->execute();
    $pendingQuotes = $stmt->fetch()['count'];
    
    // Bu ayki toplam satış
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(total_amount), 0) as total FROM orders WHERE status = 'completed' AND MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())");
    $stmt->execute();
    $monthlySales = $stmt->fetch()['total'];
    
    // Son başvurular
    $stmt = $pdo->prepare("
        SELECT qr.*, c.first_name, c.last_name, c.phone, v.brand, v.model, v.year
        FROM quote_requests qr
        JOIN customers c ON qr.customer_id = c.id
        JOIN vehicles v ON qr.vehicle_id = v.id
        ORDER BY qr.created_at DESC
        LIMIT 10
    ");
    $stmt->execute();
    $recentQuotes = $stmt->fetchAll();
    
} catch (Exception $e) {
    error_log("Dashboard error: " . $e->getMessage());
    $todayQuotes = $monthlyQuotes = $pendingQuotes = $monthlySales = 0;
    $recentQuotes = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body class="nice-body">
    <!-- NiceAdmin Sidebar -->
    <aside id="sidebar" class="nice-sidebar">
        <ul class="sidebar-nav" id="sidebar-nav">
            <li class="nav-item">
                <div class="text-center mb-4 p-3">
                    <i class="fas fa-car text-primary fa-2x"></i>
                    <h6 class="text-primary mt-2 mb-0">Araç Bakım</h6>
                </div>
            </li>
            
            <li class="nav-item">
                <a class="nav-link active" href="dashboard.php">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="quotes.php">
                    <i class="fas fa-clipboard-list"></i>
                    <span>Teklif Başvuruları</span>
                    <?php if ($pendingQuotes > 0): ?>
                        <span class="nice-badge nice-badge-danger ms-2"><?= $pendingQuotes ?></span>
                    <?php endif; ?>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="orders.php">
                    <i class="fas fa-shopping-cart"></i>
                    <span>Siparişler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="customers.php">
                    <i class="fas fa-users"></i>
                    <span>Müşteriler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="products.php">
                    <i class="fas fa-box"></i>
                    <span>Ürün/Hizmetler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="reports.php">
                    <i class="fas fa-chart-bar"></i>
                    <span>Raporlar</span>
                </a>
            </li>
            
            <?php if (isAdmin()): ?>
            <li class="nav-item">
                <a class="nav-link" href="settings.php">
                    <i class="fas fa-cog"></i>
                    <span>Ayarlar</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="users.php">
                    <i class="fas fa-user-cog"></i>
                    <span>Kullanıcılar</span>
                </a>
            </li>
            <?php endif; ?>
            
            <li class="nav-item mt-4">
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Çıkış</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- NiceAdmin Header -->
    <header id="header" class="nice-header">
        <div class="d-flex align-items-center justify-content-between">
            <div class="logo d-flex align-items-center">
                <span class="d-none d-lg-block">Dashboard</span>
            </div>
            <nav class="header-nav ms-auto">
                <ul class="d-flex align-items-center">
                    <li class="nav-item dropdown pe-3">
                        <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle fa-2x text-primary"></i>
                            <span class="d-none d-md-block dropdown-toggle ps-2"><?= h($_SESSION['user_name']) ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                            <li class="dropdown-header">
                                <h6><?= h($_SESSION['user_name']) ?></h6>
                                <span><?= ucfirst($_SESSION['user_role']) ?></span>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center" href="profile.php">
                                    <i class="fas fa-user"></i>
                                    <span>Profil</span>
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center" href="logout.php">
                                    <i class="fas fa-sign-out-alt"></i>
                                    <span>Çıkış</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </nav>
        </div>
    </header>

    <!-- NiceAdmin Main Content -->
    <main id="main" class="nice-main">
        <div class="pagetitle">
            <h1>Dashboard</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Ana Sayfa</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div>

        <section class="section dashboard">
            <div class="row">
                <!-- Left side columns -->
                <div class="col-lg-8">
                    <div class="row">
                        <!-- Sales Card -->
                        <div class="col-xxl-4 col-md-6">
                            <div class="nice-card info-card sales-card">
                                <div class="card-body">
                                    <h5 class="card-title">Bugünkü Başvuru</h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-calendar-day"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><?= $todayQuotes ?></h6>
                                            <span class="text-success small pt-1 fw-bold">12%</span> <span class="text-muted small pt-2 ps-1">artış</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Revenue Card -->
                        <div class="col-xxl-4 col-md-6">
                            <div class="nice-card info-card revenue-card">
                                <div class="card-body">
                                    <h5 class="card-title">Aylık Satış</h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-lira-sign"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><?= formatMoney($monthlySales) ?></h6>
                                            <span class="text-success small pt-1 fw-bold">8%</span> <span class="text-muted small pt-2 ps-1">artış</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Customers Card -->
                        <div class="col-xxl-4 col-xl-12">
                            <div class="nice-card info-card customers-card">
                                <div class="card-body">
                                    <h5 class="card-title">Bekleyen Başvuru</h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-hourglass-half"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><?= $pendingQuotes ?></h6>
                                            <span class="text-danger small pt-1 fw-bold">12%</span> <span class="text-muted small pt-2 ps-1">azalış</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Reports -->
                        <div class="col-12">
                            <div class="nice-card">
                                <div class="card-body">
                                    <h5 class="card-title">Raporlar <span>/Bugün</span></h5>
                                    
                                    <!-- Line Chart -->
                                    <div id="reportsChart"></div>
                                    
                                    <script>
                                        document.addEventListener("DOMContentLoaded", () => {
                                            new ApexCharts(document.querySelector("#reportsChart"), {
                                                series: [{
                                                    name: 'Satışlar',
                                                    data: [31, 40, 28, 51, 42, 82, 56],
                                                }, {
                                                    name: 'Gelir',
                                                    data: [11, 32, 45, 32, 34, 52, 41]
                                                }, {
                                                    name: 'Müşteriler',
                                                    data: [15, 11, 32, 18, 9, 24, 11]
                                                }],
                                                chart: {
                                                    height: 350,
                                                    type: 'area',
                                                    toolbar: {
                                                        show: false
                                                    },
                                                },
                                                markers: {
                                                    size: 4
                                                },
                                                colors: ['#4154f1', '#2eca6a', '#ff771d'],
                                                fill: {
                                                    type: "gradient",
                                                    gradient: {
                                                        shadeIntensity: 1,
                                                        opacityFrom: 0.3,
                                                        opacityTo: 0.4,
                                                        stops: [0, 90, 100]
                                                    }
                                                },
                                                dataLabels: {
                                                    enabled: false
                                                },
                                                stroke: {
                                                    curve: 'smooth',
                                                    width: 2
                                                },
                                                xaxis: {
                                                    type: 'datetime',
                                                    categories: ["2018-09-19T00:00:00.000Z", "2018-09-19T01:30:00.000Z", "2018-09-19T02:30:00.000Z", "2018-09-19T03:30:00.000Z", "2018-09-19T04:30:00.000Z", "2018-09-19T05:30:00.000Z", "2018-09-19T06:30:00.000Z"]
                                                },
                                                tooltip: {
                                                    x: {
                                                        format: 'dd/MM/yy HH:mm'
                                                    },
                                                }
                                            }).render();
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>

                        <!-- Recent Sales -->
                        <div class="col-12">
                            <div class="nice-card recent-sales overflow-auto">
                                <div class="card-body">
                                    <h5 class="card-title">Son Başvurular <span>| Bugün</span></h5>
                                    
                                    <table class="nice-table table-borderless datatable">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Müşteri</th>
                                                <th scope="col">Araç</th>
                                                <th scope="col">Durum</th>
                                                <th scope="col">Tarih</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($recentQuotes as $quote): ?>
                                            <tr>
                                                <th scope="row"><?= $quote['id'] ?></th>
                                                <td><?= h($quote['first_name'] . ' ' . $quote['last_name']) ?></td>
                                                <td><?= h($quote['brand'] . ' ' . $quote['model'] . ' (' . $quote['year'] . ')') ?></td>
                                                <td>
                                                    <?php
                                                    $statusClass = match($quote['status']) {
                                                        'NEW' => 'nice-badge-warning',
                                                        'QUOTE_SENT' => 'nice-badge-info',
                                                        'ACCEPTED' => 'nice-badge-success',
                                                        'REJECTED' => 'nice-badge-danger',
                                                        'CANCELLED' => 'nice-badge-secondary',
                                                        default => 'nice-badge-secondary'
                                                    };
                                                    $statusText = match($quote['status']) {
                                                        'NEW' => 'Yeni',
                                                        'QUOTE_SENT' => 'Teklif Gönderildi',
                                                        'ACCEPTED' => 'Kabul Edildi',
                                                        'REJECTED' => 'Reddedildi',
                                                        'CANCELLED' => 'İptal Edildi',
                                                        default => $quote['status']
                                                    };
                                                    ?>
                                                    <span class="nice-badge <?= $statusClass ?>"><?= $statusText ?></span>
                                                </td>
                                                <td><?= formatDate($quote['created_at'], 'd.m.Y H:i') ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right side columns -->
                <div class="col-lg-4">
                    <!-- Recent Activity -->
                    <div class="nice-card">
                        <div class="card-body">
                            <h5 class="card-title">Son Aktiviteler <span>| Bugün</span></h5>
                            
                            <div class="activity">
                                <div class="activity-item d-flex">
                                    <div class="activite-label">32 dk</div>
                                    <i class='fas fa-circle activity-badge text-success align-self-start'></i>
                                    <div class="activity-content">
                                        Yeni teklif başvurusu <a href="#" class="fw-bold text-dark">alındı</a>
                                    </div>
                                </div>
                                
                                <div class="activity-item d-flex">
                                    <div class="activite-label">56 dk</div>
                                    <i class='fas fa-circle activity-badge text-danger align-self-start'></i>
                                    <div class="activity-content">
                                        Teklif <a href="#" class="fw-bold text-dark">gönderildi</a>
                                    </div>
                                </div>
                                
                                <div class="activity-item d-flex">
                                    <div class="activite-label">2 sa</div>
                                    <i class='fas fa-circle activity-badge text-primary align-self-start'></i>
                                    <div class="activity-content">
                                        Yeni müşteri <a href="#" class="fw-bold text-dark">kaydedildi</a>
                                    </div>
                                </div>
                                
                                <div class="activity-item d-flex">
                                    <div class="activite-label">1 gün</div>
                                    <i class='fas fa-circle activity-badge text-info align-self-start'></i>
                                    <div class="activity-content">
                                        Sipariş <a href="#" class="fw-bold text-dark">tamamlandı</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Budget Report -->
                    <div class="nice-card">
                        <div class="card-body pb-0">
                            <h5 class="card-title">Bütçe Raporu <span>| Bu Ay</span></h5>
                            
                            <div id="budgetChart" style="min-height: 400px;" class="echart"></div>
                            
                            <script>
                                document.addEventListener("DOMContentLoaded", () => {
                                    var budgetChart = echarts.init(document.querySelector("#budgetChart")).setOption({
                                        legend: {
                                            data: ['Allocated Budget', 'Actual Spending']
                                        },
                                        radar: {
                                            shape: 'circle',
                                            indicator: [{
                                                name: 'Sales',
                                                max: 6500
                                            },
                                            {
                                                name: 'Administration',
                                                max: 16000
                                            },
                                            {
                                                name: 'Information Technology',
                                                max: 30000
                                            },
                                            {
                                                name: 'Customer Support',
                                                max: 38000
                                            },
                                            {
                                                name: 'Development',
                                                max: 52000
                                            },
                                            {
                                                name: 'Marketing',
                                                max: 25000
                                            }
                                            ]
                                        },
                                        series: [{
                                            name: 'Budget vs spending',
                                            type: 'radar',
                                            data: [{
                                                value: [4200, 3000, 20000, 35000, 50000, 18000],
                                                name: 'Allocated Budget'
                                            },
                                            {
                                                value: [5000, 14000, 28000, 26000, 42000, 21000],
                                                name: 'Actual Spending'
                                            }
                                            ]
                                        }]
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.0/dist/echarts.min.js"></script>
</body>
</html>
