<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/appointment_functions.php';

$pageTitle = 'Randevu Detayı';
$currentPage = 'appointments';

if (!isLoggedIn()) {
    redirect('login.php');
}

$appointmentId = intval($_GET['id'] ?? 0);

if (!$appointmentId) {
    redirect('appointments.php');
}

// Randevu bilgilerini getir
$stmt = $pdo->prepare("
    SELECT a.*, 
           c.first_name, c.last_name, c.phone, c.email, c.contact_address,
           v.brand, v.model, v.year, v.plate, v.chassis_number, v.engine_size, v.fuel_type,
           u.first_name as tech_first_name, u.last_name as tech_last_name,
           qr.problem_description, qr.preferred_date, qr.preferred_time, qr.additional_notes
    FROM appointments a
    JOIN customers c ON a.customer_id = c.id
    JOIN vehicles v ON a.vehicle_id = v.id
    LEFT JOIN users u ON a.assigned_technician_id = u.id
    LEFT JOIN quote_requests qr ON a.quote_request_id = qr.id
    WHERE a.id = ?
");
$stmt->execute([$appointmentId]);
$appointment = $stmt->fetch();

if (!$appointment) {
    redirect('appointments.php');
}

// Teknisyenleri getir
$stmt = $pdo->prepare("SELECT id, first_name, last_name FROM users WHERE role IN ('admin', 'technician') ORDER BY first_name, last_name");
$stmt->execute();
$technicians = $stmt->fetchAll();

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Başlık -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h4 class="mb-1">Randevu Detayı #<?= $appointment['id'] ?></h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="appointments.php">Randevular</a></li>
                            <li class="breadcrumb-item active">Detay</li>
                        </ol>
                    </nav>
                </div>
                <div class="d-flex gap-2">
                    <span class="nice-badge nice-badge-<?= getAppointmentStatusClass($appointment['status']) ?> fs-6">
                        <?= getAppointmentStatusText($appointment['status']) ?>
                    </span>
                </div>
            </div>
            
            <div class="row">
                <!-- Sol Kolon - Randevu Bilgileri -->
                <div class="col-md-8">
                    <!-- Randevu Bilgileri -->
                    <div class="nice-card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-calendar-alt text-primary me-2"></i>
                                Randevu Bilgileri
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-item mb-3">
                                        <label class="info-label">Randevu Tarihi</label>
                                        <span class="info-value fw-bold text-primary">
                                            <?= formatDate($appointment['appointment_date'], 'd.m.Y') ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Randevu Saati</label>
                                        <span class="info-value fw-bold">
                                            <?= date('H:i', strtotime($appointment['appointment_time'])) ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Süre</label>
                                        <span class="info-value">
                                            <?= $appointment['duration_minutes'] ?> dakika
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="info-item mb-3">
                                        <label class="info-label">Hizmet Türü</label>
                                        <span class="nice-badge nice-badge-info">
                                            <?= h($appointment['service_type']) ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Oluşturulma</label>
                                        <span class="info-value">
                                            <?= formatDate($appointment['created_at'], 'd.m.Y H:i') ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Son Güncelleme</label>
                                        <span class="info-value">
                                            <?= formatDate($appointment['updated_at'], 'd.m.Y H:i') ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if ($appointment['notes']): ?>
                            <div class="info-item">
                                <label class="info-label">Müşteri Notları</label>
                                <div class="info-value">
                                    <?= nl2br(h($appointment['notes'])) ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if ($appointment['admin_notes']): ?>
                            <div class="info-item mt-3">
                                <label class="info-label">Admin Notları</label>
                                <div class="info-value">
                                    <?= nl2br(h($appointment['admin_notes'])) ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Müşteri Bilgileri -->
                    <div class="nice-card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-user text-info me-2"></i>
                                Müşteri Bilgileri
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-item mb-3">
                                        <label class="info-label">Ad Soyad</label>
                                        <span class="info-value fw-bold">
                                            <?= h($appointment['first_name'] . ' ' . $appointment['last_name']) ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Telefon</label>
                                        <span class="info-value">
                                            <a href="tel:<?= h($appointment['phone']) ?>" class="text-decoration-none">
                                                <i class="fas fa-phone me-1"></i><?= h($appointment['phone']) ?>
                                            </a>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="info-item mb-3">
                                        <label class="info-label">E-posta</label>
                                        <span class="info-value">
                                            <?php if ($appointment['email']): ?>
                                            <a href="mailto:<?= h($appointment['email']) ?>" class="text-decoration-none">
                                                <i class="fas fa-envelope me-1"></i><?= h($appointment['email']) ?>
                                            </a>
                                            <?php else: ?>
                                            <span class="text-muted">E-posta yok</span>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if ($appointment['contact_address']): ?>
                            <div class="info-item">
                                <label class="info-label">Adres</label>
                                <div class="info-value">
                                    <?= nl2br(h($appointment['contact_address'])) ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Araç Bilgileri -->
                    <div class="nice-card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-car text-success me-2"></i>
                                Araç Bilgileri
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-item mb-3">
                                        <label class="info-label">Marka Model</label>
                                        <span class="info-value fw-bold">
                                            <?= h($appointment['brand'] . ' ' . $appointment['model']) ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Model Yılı</label>
                                        <span class="info-value">
                                            <?= h($appointment['year']) ?>
                                        </span>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <label class="info-label">Plaka</label>
                                        <span class="info-value">
                                            <?= h($appointment['plate'] ?: 'Belirtilmemiş') ?>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <?php if ($appointment['chassis_number']): ?>
                                    <div class="info-item mb-3">
                                        <label class="info-label">Şase No</label>
                                        <span class="info-value">
                                            <?= h($appointment['chassis_number']) ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($appointment['engine_size']): ?>
                                    <div class="info-item mb-3">
                                        <label class="info-label">Motor Hacmi</label>
                                        <span class="info-value">
                                            <?= h($appointment['engine_size']) ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($appointment['fuel_type']): ?>
                                    <div class="info-item mb-3">
                                        <label class="info-label">Yakıt Türü</label>
                                        <span class="info-value">
                                            <?= h($appointment['fuel_type']) ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Teklif Talebi Bilgileri -->
                    <?php if ($appointment['quote_request_id']): ?>
                    <div class="nice-card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-file-invoice text-warning me-2"></i>
                                İlgili Teklif Talebi
                            </h6>
                        </div>
                        <div class="card-body">
                            <?php if ($appointment['problem_description']): ?>
                            <div class="info-item mb-3">
                                <label class="info-label">Problem Açıklaması</label>
                                <div class="info-value">
                                    <?= nl2br(h($appointment['problem_description'])) ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if ($appointment['additional_notes']): ?>
                            <div class="info-item mb-3">
                                <label class="info-label">Ek Notlar</label>
                                <div class="info-value">
                                    <?= nl2br(h($appointment['additional_notes'])) ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <div class="d-flex gap-2">
                                <a href="quote_detail.php?id=<?= $appointment['quote_request_id'] ?>" class="nice-btn nice-btn-sm nice-btn-outline-primary">
                                    <i class="fas fa-eye me-1"></i>Teklif Talebini Görüntüle
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Sağ Kolon - İşlemler -->
                <div class="col-md-4">
                    <!-- Hızlı İşlemler -->
                    <div class="nice-card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-cogs text-primary me-2"></i>
                                Hızlı İşlemler
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <?php if ($appointment['status'] === 'PENDING'): ?>
                                <button class="nice-btn nice-btn-success" onclick="updateStatus('CONFIRMED')">
                                    <i class="fas fa-check me-2"></i>Onayla
                                </button>
                                <?php endif; ?>
                                
                                <?php if (in_array($appointment['status'], ['PENDING', 'CONFIRMED'])): ?>
                                <button class="nice-btn nice-btn-primary" onclick="updateStatus('IN_PROGRESS')">
                                    <i class="fas fa-play me-2"></i>Başlat
                                </button>
                                <?php endif; ?>
                                
                                <?php if ($appointment['status'] === 'IN_PROGRESS'): ?>
                                <button class="nice-btn nice-btn-success" onclick="updateStatus('COMPLETED')">
                                    <i class="fas fa-check-circle me-2"></i>Tamamla
                                </button>
                                <?php endif; ?>
                                
                                <?php if (!$appointment['reminder_sent'] && $appointment['status'] !== 'CANCELLED'): ?>
                                <button class="nice-btn nice-btn-info" onclick="sendReminder()">
                                    <i class="fas fa-bell me-2"></i>Hatırlatma Gönder
                                </button>
                                <?php endif; ?>
                                
                                <?php if (!in_array($appointment['status'], ['COMPLETED', 'CANCELLED'])): ?>
                                <button class="nice-btn nice-btn-danger" onclick="updateStatus('CANCELLED')">
                                    <i class="fas fa-times me-2"></i>İptal Et
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Teknisyen Ataması -->
                    <div class="nice-card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-user-cog text-info me-2"></i>
                                Teknisyen Ataması
                            </h6>
                        </div>
                        <div class="card-body">
                            <?php if ($appointment['tech_first_name']): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-user-check me-2"></i>
                                <strong>Atanan Teknisyen:</strong><br>
                                <?= h($appointment['tech_first_name'] . ' ' . $appointment['tech_last_name']) ?>
                            </div>
                            <?php else: ?>
                            <div class="alert alert-warning">
                                <i class="fas fa-user-times me-2"></i>
                                Henüz teknisyen atanmadı.
                            </div>
                            <?php endif; ?>
                            
                            <select class="nice-form-control mb-3" id="technician_select">
                                <option value="">Teknisyen seçin</option>
                                <?php foreach ($technicians as $technician): ?>
                                <option value="<?= $technician['id'] ?>" <?= ($appointment['assigned_technician_id'] == $technician['id']) ? 'selected' : '' ?>>
                                    <?= h($technician['first_name'] . ' ' . $technician['last_name']) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                            
                            <button class="nice-btn nice-btn-primary w-100" onclick="assignTechnician()">
                                <i class="fas fa-user-plus me-2"></i>Teknisyen Ata
                            </button>
                        </div>
                    </div>
                    
                    <!-- Admin Notları -->
                    <div class="nice-card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-sticky-note text-warning me-2"></i>
                                Admin Notları
                            </h6>
                        </div>
                        <div class="card-body">
                            <textarea class="nice-form-control mb-3" id="admin_notes" rows="4" 
                                    placeholder="Admin notları..."><?= h($appointment['admin_notes']) ?></textarea>
                            <button class="nice-btn nice-btn-primary w-100" onclick="saveAdminNotes()">
                                <i class="fas fa-save me-2"></i>Notları Kaydet
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Randevu durumu güncelle
function updateStatus(status) {
    const statusTexts = {
        'CONFIRMED': 'onaylamak',
        'IN_PROGRESS': 'başlatmak',
        'COMPLETED': 'tamamlamak',
        'CANCELLED': 'iptal etmek'
    };
    
    if (confirm(`Randevuyu ${statusTexts[status]} istediğinizden emin misiniz?`)) {
        const adminNotes = document.getElementById('admin_notes').value;
        
        fetch('appointment_actions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                action: 'update_status',
                appointment_id: <?= $appointmentId ?>,
                status: status,
                admin_notes: adminNotes
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Hata: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Bir hata oluştu.');
        });
    }
}

// Hatırlatma gönder
function sendReminder() {
    if (confirm('Müşteriye randevu hatırlatması göndermek istediğinizden emin misiniz?')) {
        fetch('appointment_actions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                action: 'send_reminder',
                appointment_id: <?= $appointmentId ?>
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Hatırlatma başarıyla gönderildi.');
                location.reload();
            } else {
                alert('Hata: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Bir hata oluştu.');
        });
    }
}

// Teknisyen ata
function assignTechnician() {
    const technicianId = document.getElementById('technician_select').value;
    
    fetch('appointment_actions.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            action: 'assign_technician',
            appointment_id: <?= $appointmentId ?>,
            technician_id: technicianId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Teknisyen başarıyla atandı.');
            location.reload();
        } else {
            alert('Hata: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu.');
    });
}

// Admin notlarını kaydet
function saveAdminNotes() {
    const adminNotes = document.getElementById('admin_notes').value;
    
    fetch('appointment_actions.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            action: 'update_status',
            appointment_id: <?= $appointmentId ?>,
            status: '<?= $appointment['status'] ?>',
            admin_notes: adminNotes
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Admin notları başarıyla kaydedildi.');
        } else {
            alert('Hata: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu.');
    });
}
</script>

<style>
.info-item {
    margin-bottom: 1rem;
}

.info-label {
    display: block;
    font-size: 0.875rem;
    font-weight: 500;
    color: #6b7280;
    margin-bottom: 0.25rem;
}

.info-value {
    display: block;
    font-size: 1rem;
    color: #374151;
}
</style>

<?php include 'includes/footer.php'; ?>
